/*****************************************************************************
 *   SE95.c:  SE95 temperature sensor C file for NXP LPC29xx Family 
 *   Microprocessors
 *
 *   Copyright(C) 2008, NXP Semiconductor
 *   All rights reserved.
 *
 *   History
 *	 2009.4   ver 2.00    LPC29xx Codebundle update
 *
 ****************************************************************************
 * Software that is described herein is for illustrative purposes only
 * which provides customers with programming information regarding the
 * products. This software is supplied "AS IS" without any warranties.
 * NXP Semiconductors assumes no responsibility or liability for the
 * use of the software, conveys no license or title under any patent,
 * copyright, or mask work right to the product. NXP Semiconductors
 * reserves the right to make changes in the software without
 * notification. NXP Semiconductors also make no representation or
 * warranty that such application will be suitable for the specified
 * use without further testing or modification.
 *****************************************************************************/

#include "LPC29xx.h"
#include "type.h"
#include "timer.h"
#include "irq.h"
#include "i2c.h"
#include "SE95.h"

/* I2C extern variable declarations */
extern volatile BYTE I2C0Buffer[I2CBUFSIZE];
extern volatile BYTE I2C1Buffer[I2CBUFSIZE];
extern volatile BYTE I2C0state;
extern volatile BYTE I2C1state;
extern volatile BYTE I2C0txBytes;

volatile double SE95_temp=0;

/*****************************************************************************
** Function name:		init_SE95
**
** Descriptions:		Initialize SE95 temperature sensor
**
** parameters:			NONE
** Returned value:	returns the SE95 manufacturer ID
**				           
*****************************************************************************/
BYTE SE95_init(void)
{
	/* Initialize I2C0 as Master */
	if (I2CInit (I2C0, I2CMASTER) == FALSE) { while (1); }

	/* Init SE95 */
	/* Set the pointer byte to the Conf register */
	I2C0Buffer[0] = SE95_CONF; 
	I2C0Buffer[1] = 0x00; /* Set the CONF register as wished*/
	I2C0txBytes = 2;
	I2C0start(WRITE);

	/* Wait until write is done */
  while (I2C0state != I2C_IDLE);
 	
	/*** Read manufacturer ID ***/
	/* First set the data pointer to 0x05 */
	I2C0Buffer[0] = SE95_ID; 
	I2C0txBytes = 1;
	I2C0start(WRITE);

	/* Wait until write is done */
  while (I2C0state != I2C_RESTARTED);
	
	/* Than read the ID register */
	I2C0start(READ);

 	/* Wait until write is done */
  while (I2C0state != I2C_IDLE);

	/* Return the Manufacturer ID */
	return (I2C0Buffer[0]);
}



BYTE SE95_read_temp(void)
{
	static BYTE temp;
	/* Check the I2C state */
	switch (I2C0state)
	{
		/* Start if I2C is available */
		case I2C_IDLE:
			temp = I2C0Buffer[0]; 
			/* Set pointer to 0x00 --> Temperature data */
			I2C0Buffer[0] = 0x00; 
			I2C0txBytes = 1;
			I2C0start(WRITE);
			break;
		/* If data pointer is set, restart I2C to read values */
		case I2C_RESTARTED:
			I2C0start(READ);
			break;
		default:
			break;
	}
	return temp;
}

/******************************************************************************
**                            End Of File
******************************************************************************/
